/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.DataLabelTable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.event.TableModelEvent;

public class SimpleDataLabelTable
extends DataLabelTable {
    Vector<Vector<String>> fullData;

    public SimpleDataLabelTable() {
    }

    public SimpleDataLabelTable(Aladin aladin, Vector<Vector<String>> dataLabels) {
        super(aladin);
        this.fullData = dataLabels;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.fullData != null) {
            result = this.fullData.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Vector<String> data = this.fullData.get(rowIndex);
        if (columnIndex <= data.size()) {
            return data.elementAt(columnIndex);
        }
        return "";
    }

    @Override
    public void defaultSortServers() {
        Collections.sort(this.fullData, new Comparator<Vector<String>>(){

            @Override
            public int compare(Vector<String> o1, Vector<String> o2) {
                int n = o1.get(0).compareTo(o2.get(0));
                if (n != 0) {
                    return n;
                }
                return o1.get(2).compareTo(o2.get(2));
            }
        });
        if (!this.ascSort) {
            Collections.reverse(this.fullData);
        }
        this.ascSort = !this.ascSort;
    }

    @Override
    public Vector<String> getDataLabelAt(int rowIndex) {
        return this.fullData.get(rowIndex);
    }

    @Override
    public void notifyTableChanged() {
        int n = this.fullData.size();
        if (this.tableListener != null) {
            this.tableListener.tableChanged(new TableModelEvent(this, n, n, -1, 1));
        }
    }
}

